/*
 * Decompiled with CFR 0.152.
 */
package mod.geochests;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import mod.geochests.GeoChest;
import mod.geochests.GeoChestInventory;
import mod.geochests.GeoChestItem;
import mod.geochests.GeoChestTileEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CraftingEventListener {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(PlayerEvent.ItemCraftedEvent event) {
        ItemStack item = event.crafting;
        IInventory craftMatrix = event.craftMatrix;
        if (item.func_77973_b() instanceof GeoChestItem && craftMatrix.func_70301_a(4).func_77973_b() instanceof GeoChestItem) {
            GeoChestTileEntity srcTileEntity = new GeoChestTileEntity();
            srcTileEntity.func_145839_a(craftMatrix.func_70301_a((int)4).field_77990_d);
            int srcSize = srcTileEntity.getSize();
            int dstSize = Math.max(3, srcSize) + 2;
            GeoChestTileEntity dstTileEntity = new GeoChestTileEntity(dstSize);
            for (int i = 0; i < srcSize; ++i) {
                GeoChestInventory srcInventory = srcTileEntity.getInventories().get(i);
                GeoChestInventory dstInventory = dstTileEntity.getInventories().get(i);
                for (int j = 0; j < srcSize; ++j) {
                    for (int k = 0; k < srcSize; ++k) {
                        int srcSlot = j + k * srcSize;
                        int dstSlot = j + 1 + (k + 2) * dstSize;
                        dstInventory.setInventoryBlockID(dstSlot, srcInventory.getBlockIDInSlot(srcSlot));
                        dstInventory.setInventoryMetadata(dstSlot, srcInventory.getMetadataInSlot(srcSlot));
                        dstInventory.func_70299_a(dstSlot, srcInventory.func_70301_a(srcSlot));
                        dstInventory.setInventorySlotNBT(dstSlot, srcInventory.getNBTInSlot(srcSlot));
                    }
                }
            }
            dstTileEntity.copyDetails(srcTileEntity);
            item.field_77990_d = new NBTTagCompound();
            dstTileEntity.func_145841_b(item.field_77990_d);
            String newTextColourTag = GeoChest.sizeToStringColourTag(dstSize);
            String name = dstTileEntity.getName();
            if (name.length() > 0) {
                item.field_77990_d.func_74778_a("ItemName", newTextColourTag + name);
                item.func_151001_c(GeoChest.sizeToName(dstSize) + newTextColourTag + " (" + name + ")");
            }
        }
    }
}

