/*
 * Decompiled with CFR 0.152.
 */
package mod.geochests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mod.geochests.GeoChestTileEntity;
import mod.geochests.GeovisualizerItem;
import mod.geochests.ModGeoChests;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class GeoChest
extends BlockContainer {
    public static final int TINY_GEOCHEST = 0;
    public static final int SMALL_GEOCHEST = 1;
    public static final int MEDIUM_GEOCHEST = 2;
    public static final int LARGE_GEOCHEST = 3;
    public static final int HUGE_GEOCHEST = 4;
    public static final int TEST_GEOCHEST = 5;
    private int type = 0;
    private ResourceLocation texture = null;
    private ResourceLocation alignedTexture = null;
    private ResourceLocation particleTexture = null;
    private ResourceLocation guiTexture = null;
    private ResourceLocation guiButtonPanelTexure = null;

    public GeoChest(int type, String name) {
        super(Material.field_151575_d);
        this.type = type;
        switch (this.type) {
            default: {
                this.texture = new ResourceLocation("geochests", "textures/entity/chest/tinygeochest.png");
                this.alignedTexture = new ResourceLocation("geochests", "textures/entity/chest/tinygeochest_a.png");
                this.particleTexture = new ResourceLocation("geochests", "textures/particles/tinygeochest.png");
                this.guiTexture = new ResourceLocation("geochests", "textures/gui/tinygeochest.png");
                break;
            }
            case 1: {
                this.texture = new ResourceLocation("geochests", "textures/entity/chest/smallgeochest.png");
                this.alignedTexture = new ResourceLocation("geochests", "textures/entity/chest/smallgeochest_a.png");
                this.particleTexture = new ResourceLocation("geochests", "textures/particles/smallgeochest.png");
                this.guiTexture = new ResourceLocation("geochests", "textures/gui/smallgeochest.png");
                break;
            }
            case 2: {
                this.texture = new ResourceLocation("geochests", "textures/entity/chest/mediumgeochest.png");
                this.alignedTexture = new ResourceLocation("geochests", "textures/entity/chest/mediumgeochest_a.png");
                this.particleTexture = new ResourceLocation("geochests", "textures/particles/mediumgeochest.png");
                this.guiTexture = new ResourceLocation("geochests", "textures/gui/mediumgeochest.png");
                break;
            }
            case 3: {
                this.texture = new ResourceLocation("geochests", "textures/entity/chest/largegeochest.png");
                this.alignedTexture = new ResourceLocation("geochests", "textures/entity/chest/largegeochest_a.png");
                this.particleTexture = new ResourceLocation("geochests", "textures/particles/largegeochest.png");
                this.guiTexture = new ResourceLocation("geochests", "textures/gui/largegeochest.png");
                break;
            }
            case 4: {
                this.texture = new ResourceLocation("geochests", "textures/entity/chest/hugegeochest.png");
                this.alignedTexture = new ResourceLocation("geochests", "textures/entity/chest/hugegeochest_a.png");
                this.particleTexture = new ResourceLocation("geochests", "textures/particles/hugegeochest.png");
                this.guiTexture = new ResourceLocation("geochests", "textures/gui/hugegeochest.png");
                break;
            }
            case 5: {
                this.texture = new ResourceLocation("geochests", "textures/entity/chest/tinygeochest.png");
                this.alignedTexture = new ResourceLocation("geochests", "textures/entity/chest/tinygeochest_a.png");
                this.particleTexture = new ResourceLocation("geochests", "textures/particles/tinygeochest.png");
                this.guiTexture = new ResourceLocation("geochests", "textures/gui/tinygeochest.png");
            }
        }
        this.guiButtonPanelTexure = new ResourceLocation("geochests", "textures/gui/buttonpanel.png");
        this.func_149711_c(1.0f);
        this.func_149672_a(field_149766_f);
        this.func_149663_c(name);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 22;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150899_d((int)Block.func_149682_b((Block)this));
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return true;
    }

    protected void dropChestAsItemWithNBT(World world, int x, int y, int z) {
        ItemStack itemStack = new ItemStack((Block)this);
        GeoChestTileEntity tileEntity = (GeoChestTileEntity)world.func_147438_o(x, y, z);
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        tileEntity.func_145841_b(itemStack.field_77990_d);
        String name = tileEntity.getName();
        if (name.length() > 0) {
            itemStack.field_77990_d.func_74778_a("ItemName", this.getStringColourTag() + tileEntity.getName());
            itemStack.func_151001_c(this.getItemName() + this.getStringColourTag() + " (" + tileEntity.getName() + ")");
        }
        this.func_149642_a(world, x, y, z, itemStack);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.dropChestAsItemWithNBT(world, x, y, z);
        }
        return world.func_147468_f(x, y, z);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (!world.field_72995_K) {
            this.dropChestAsItemWithNBT(world, x, y, z);
        }
        world.func_147468_f(x, y, z);
        this.func_149723_a(world, x, y, z, explosion);
    }

    public void func_149725_f(World world, int x, int y, int z, int metadata) {
        super.func_149725_f(world, x, y, z, metadata);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase livingBase, ItemStack itemStack) {
        int newRotation = 0;
        int l = MathHelper.func_76128_c((double)((double)(livingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            newRotation = 0;
        } else if (l == 1) {
            newRotation = 1;
        } else if (l == 2) {
            newRotation = 2;
        } else if (l == 3) {
            newRotation = 3;
        }
        world.func_72921_c(x, y, z, newRotation, 2);
        GeoChestTileEntity tileEntity = (GeoChestTileEntity)world.func_147438_o(x, y, z);
        if (itemStack.field_77990_d != null) {
            tileEntity.func_145839_a(itemStack.field_77990_d);
            tileEntity.field_145851_c = x;
            tileEntity.field_145848_d = y;
            tileEntity.field_145849_e = z;
            tileEntity.setCurrentDirection(newRotation);
        } else {
            tileEntity.setOriginalDirection(newRotation);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item item;
        ItemStack heldItemStack = player.func_71045_bC();
        if (heldItemStack != null && heldItemStack.func_77973_b() != null && (item = heldItemStack.func_77973_b()) instanceof GeovisualizerItem) {
            GeoChestTileEntity tileEntity;
            if (world.field_72995_K && (tileEntity = (GeoChestTileEntity)world.func_147438_o(x, y, z)) != null) {
                tileEntity.toggleVisualization();
            }
            return true;
        }
        if (world.func_147445_c(x, y + 1, z, false)) {
            return true;
        }
        if (world.field_72995_K) {
            GeoChestTileEntity tileEntity = (GeoChestTileEntity)world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                tileEntity.openChest();
            }
            player.openGui((Object)ModGeoChests.instance, 0, world, x, y, z);
            return true;
        }
        player.openGui((Object)ModGeoChests.instance, 0, world, x, y, z);
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbourBlock) {
        boolean wasPowered;
        boolean isPowered = world.func_72864_z(x, y - 1, z);
        int metaData = world.func_72805_g(x, y, z);
        boolean bl = wasPowered = (metaData & 4) > 0;
        if (isPowered && !wasPowered) {
            GeoChestTileEntity tileEntity = (GeoChestTileEntity)world.func_147438_o(x, y, z);
            tileEntity.swap(1, null);
            world.func_72921_c(x, y, z, metaData | 4, 2);
        } else if (!isPowered && wasPowered) {
            world.func_72921_c(x, y, z, metaData & 0xFFFFFFFB, 2);
        }
    }

    public TileEntity func_149915_a(World par1World, int metadata) {
        GeoChestTileEntity tileEntity = new GeoChestTileEntity(this.getSize());
        tileEntity.field_145854_h = this;
        tileEntity.field_145847_g = metadata;
        return tileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        for (int l = 0; l < 3; ++l) {
            double churn_rand = (float)par2 + par5Random.nextFloat();
            double y = (float)par3 + par5Random.nextFloat();
            churn_rand = (float)par4 + par5Random.nextFloat();
            double velX = 0.0;
            double vely = 0.0;
            double velz = 0.0;
            int i1 = par5Random.nextInt(2) * 2 - 1;
            int j1 = par5Random.nextInt(2) * 2 - 1;
            velX = ((double)par5Random.nextFloat() - 0.5) * 0.125;
            vely = ((double)par5Random.nextFloat() - 0.5) * 0.125;
            velz = ((double)par5Random.nextFloat() - 0.5) * 0.125;
            double z = (double)par4 + 0.5 + 0.25 * (double)j1;
            velz = par5Random.nextFloat() * 1.0f * (float)j1;
            double x = (double)par2 + 0.5 + 0.25 * (double)i1;
            velX = par5Random.nextFloat() * 1.0f * (float)i1;
            par1World.func_72869_a("portal", x, y, z, velX, vely, velz);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        switch (this.type) {
            default: {
                this.field_149761_L = par1IconRegister.func_94245_a("wool_colored_white");
                break;
            }
            case 1: {
                this.field_149761_L = par1IconRegister.func_94245_a("wool_colored_yellow");
                break;
            }
            case 2: {
                this.field_149761_L = par1IconRegister.func_94245_a("wool_colored_blue");
                break;
            }
            case 3: {
                this.field_149761_L = par1IconRegister.func_94245_a("wool_colored_red");
                break;
            }
            case 4: {
                this.field_149761_L = par1IconRegister.func_94245_a("wool_colored_black");
                break;
            }
            case 5: {
                this.field_149761_L = par1IconRegister.func_94245_a("cloth_0");
            }
        }
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ResourceLocation getAlignedTexture() {
        return this.alignedTexture;
    }

    public ResourceLocation getParticleTexture() {
        return this.particleTexture;
    }

    public ResourceLocation getGuiTexture() {
        return this.guiTexture;
    }

    public ResourceLocation getButtonPanelTexture() {
        return this.guiButtonPanelTexure;
    }

    public static String sizeToStringColourTag(int size) {
        switch (size) {
            default: {
                return "\u00a77";
            }
            case 5: {
                return "\u00a7e";
            }
            case 7: {
                return "\u00a7b";
            }
            case 9: {
                return "\u00a7c";
            }
            case 11: {
                return "\u00a78";
            }
            case 1: 
        }
        return "\u00a7f";
    }

    public String getStringColourTag() {
        switch (this.type) {
            default: {
                return "\u00a77";
            }
            case 1: {
                return "\u00a7e";
            }
            case 2: {
                return "\u00a7b";
            }
            case 3: {
                return "\u00a7c";
            }
            case 4: {
                return "\u00a78";
            }
            case 5: 
        }
        return "\u00a7f";
    }

    public static String sizeToName(int size) {
        switch (size) {
            default: {
                return "Tiny Geochest";
            }
            case 5: {
                return "Small Geochest";
            }
            case 7: {
                return "Medium Geochest";
            }
            case 9: {
                return "Large Geochest";
            }
            case 11: {
                return "Huge Geochest";
            }
            case 1: 
        }
        return "Test Geochest";
    }

    public String getItemName() {
        switch (this.type) {
            default: {
                return "Tiny Geochest";
            }
            case 1: {
                return "Small Geochest";
            }
            case 2: {
                return "Medium Geochest";
            }
            case 3: {
                return "Large Geochest";
            }
            case 4: {
                return "Huge Geochest";
            }
            case 5: 
        }
        return "Test Geochest";
    }

    public int getSize() {
        switch (this.type) {
            default: {
                return 3;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 11;
            }
            case 5: 
        }
        return 1;
    }

    public int getGuiWidth() {
        switch (this.type) {
            default: {
                return 100;
            }
            case 1: {
                return 136;
            }
            case 2: {
                return 172;
            }
            case 3: {
                return 208;
            }
            case 4: {
                return 244;
            }
            case 5: 
        }
        return 100;
    }

    public int getGuiHeight() {
        switch (this.type) {
            default: {
                return 90;
            }
            case 1: {
                return 126;
            }
            case 2: {
                return 162;
            }
            case 3: {
                return 198;
            }
            case 4: {
                return 234;
            }
            case 5: 
        }
        return 90;
    }
}

