/*
 * Decompiled with CFR 0.152.
 */
package mod.geochests;

import mod.geochests.GeoChestTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GeoChestInventory
extends InventoryBasic {
    private GeoChestTileEntity associatedChest;
    private NBTTagCompound[] inventoryNBT = new NBTTagCompound[121];
    private int[] inventoryMetadata = new int[121];
    private int[] inventoryBlockID = new int[121];

    public GeoChestInventory() {
        super("container.geochest", false, 121);
    }

    public void setAssociatedChest(GeoChestTileEntity tileEntity) {
        this.associatedChest = tileEntity;
    }

    public GeoChestTileEntity getAssociatedChest() {
        return this.associatedChest;
    }

    public void setInventorySlotNBT(int i, NBTTagCompound nbtTag) {
        this.inventoryNBT[i] = nbtTag;
    }

    public NBTTagCompound getNBTInSlot(int i) {
        return this.inventoryNBT[i];
    }

    public void setInventoryMetadata(int i, int metadata) {
        this.inventoryMetadata[i] = metadata;
    }

    public int getMetadataInSlot(int i) {
        return this.inventoryMetadata[i];
    }

    public void setInventoryBlockID(int i, int blockID) {
        this.inventoryBlockID[i] = blockID;
    }

    public int getBlockIDInSlot(int i) {
        return this.inventoryBlockID[i];
    }

    public void loadInventoryFromNBT(NBTTagList par1NBTTagList) {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
        for (i = 0; i < par1NBTTagList.func_74745_c(); ++i) {
            NBTTagCompound blockNBT;
            NBTTagCompound nbttagcompound = par1NBTTagList.func_150305_b(i * 2);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            int metadata = nbttagcompound.func_74771_c("Metadata") & 0xFF;
            int blockID = nbttagcompound.func_74762_e("BlockID");
            if (j >= 0 && j < this.func_70302_i_()) {
                this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
            }
            if ((blockNBT = par1NBTTagList.func_150305_b(i * 2 + 1)) == null || (j = blockNBT.func_74771_c("Slot") & 0xFF) < 0 || j >= this.func_70302_i_()) continue;
            this.setInventorySlotNBT(j, blockNBT);
        }
    }

    public NBTTagList saveInventoryToNBT() {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            nbttagcompound.func_74774_a("Metadata", (byte)this.inventoryMetadata[i]);
            nbttagcompound.func_74768_a("BlockID", this.inventoryBlockID[i]);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            NBTTagCompound blockNBT = this.inventoryNBT[i];
            if (blockNBT == null) {
                blockNBT = new NBTTagCompound();
            }
            blockNBT.func_74774_a("Slot", (byte)i);
            nbttaglist.func_74742_a((NBTBase)blockNBT);
        }
        return nbttaglist;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.associatedChest != null && !this.associatedChest.isUseableByPlayer(par1EntityPlayer) ? false : super.func_70300_a(par1EntityPlayer);
    }

    public void func_70295_k_() {
        if (this.associatedChest != null) {
            this.associatedChest.openChest();
        }
        super.func_70295_k_();
    }

    public void func_70305_f() {
        if (this.associatedChest != null) {
            this.associatedChest.closeChest();
        }
        super.func_70305_f();
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }
}

