/*
 * Decompiled with CFR 0.152.
 */
package mod.geochests;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import mod.geochests.GeoChest;
import mod.geochests.GeoChestInventory;
import mod.geochests.ModGeoChests;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class GeoChestTileEntity
extends TileEntity {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int DIRECTION_MASK = 3;
    public static final int POWERED_MASK = 4;
    public static final int SUCCESS = 0;
    public static final int FAIL_TOO_MANY_CHESTS = 1;
    public static final int FAIL_TOO_MANY_BLOCKS = 2;
    public static final int FAIL_TOO_WIDE = 3;
    public static final int FAIL_TOO_HIGH = 4;
    public static final int FAIL_TOO_DEEP = 5;
    public static final int FAIL_NBT_TOO_LARGE = 6;
    public static final boolean VERBOSE_MODE_ON = false;
    public static final boolean NAMES_FROM_SIGNS = false;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    private int ticksSinceSync;
    private ArrayList<GeoChestInventory> m_inventories = new ArrayList();
    private int m_size = 0;
    private String m_name = "";
    private int m_iMin = 0;
    private int m_jMin = 0;
    private int m_kMin = 0;
    private ArrayList<ItemStack> m_itemStacksTemp = new ArrayList();
    private ArrayList<NBTTagCompound> m_itemNBTTemp = new ArrayList();
    private ArrayList<Integer> m_itemBlockID = new ArrayList();
    private ArrayList<Integer> m_itemMetadata = new ArrayList();
    private ArrayList<Point3D> m_pointsInTemp = new ArrayList();
    private ArrayList<Point3D> m_pointsOutTemp = new ArrayList();
    private ArrayList<Range3D> m_exclude = new ArrayList();
    private ArrayList<Range3D> m_childExclude = new ArrayList();
    private ArrayList<GeoChestTileEntity> m_geoChestsChainIn = new ArrayList();
    private ArrayList<GeoChestTileEntity> m_geoChestsChainOut = new ArrayList();
    private ChainInfo m_chainInfo = null;
    private int m_swapType = 0;
    private boolean m_isSwapping = false;
    private int m_swapDir = 0;
    private int m_prevSwapDir = 0;
    private int m_swapResult = 0;
    private boolean m_visualization = false;

    public GeoChestTileEntity() {
    }

    public GeoChestTileEntity(int size) {
        this.m_size = size;
        switch (this.m_size) {
            case 3: {
                this.field_145854_h = ModGeoChests.tinyGeochest;
                break;
            }
            case 5: {
                this.field_145854_h = ModGeoChests.smallGeochest;
                break;
            }
            case 7: {
                this.field_145854_h = ModGeoChests.mediumGeochest;
                break;
            }
            case 9: {
                this.field_145854_h = ModGeoChests.largeGeochest;
                break;
            }
            case 11: {
                this.field_145854_h = ModGeoChests.hugeGeochest;
                break;
            }
        }
    }

    public ArrayList<GeoChestInventory> getInventories() {
        if (this.m_inventories.size() == 0) {
            for (int i = 0; i < this.m_size; ++i) {
                GeoChestInventory inventory = new GeoChestInventory();
                inventory.setAssociatedChest(this);
                this.m_inventories.add(inventory);
            }
        }
        return this.m_inventories;
    }

    public void putInInventory(int i, int j, int k, int blockID, int metadata, ItemStack itemStack, NBTTagCompound nbtTag) {
        int inventoryIndex = i + j * this.m_size;
        this.m_inventories.get(k).func_70299_a(inventoryIndex, itemStack);
        this.m_inventories.get(k).setInventorySlotNBT(inventoryIndex, nbtTag);
        this.m_inventories.get(k).setInventoryBlockID(inventoryIndex, blockID);
        this.m_inventories.get(k).setInventoryMetadata(inventoryIndex, metadata);
    }

    public ItemStack getFromInventory(int i, int j, int k) {
        int blockID = this.getInventories().get(k).getBlockIDInSlot(i + j * this.m_size);
        int metadata = this.getInventories().get(k).getMetadataInSlot(i + j * this.m_size);
        NBTTagCompound nbt = this.getInventories().get(k).getNBTInSlot(i + j * this.m_size);
        ItemStack itemStack = new ItemStack(Block.func_149729_e((int)blockID), 1, metadata);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public NBTTagCompound getNBTFromInventory(int i, int j, int k) {
        return this.getInventories().get(k).getNBTInSlot(i + j * this.m_size);
    }

    public int getBlockIDFromInventory(int i, int j, int k) {
        return this.getInventories().get(k).getBlockIDInSlot(i + j * this.m_size);
    }

    public int getMetadataFromInventory(int i, int j, int k) {
        return this.getInventories().get(k).getMetadataInSlot(i + j * this.m_size);
    }

    public void func_145845_h() {
        double d0;
        super.func_145845_h();
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.field_145851_c + 0.5;
            d0 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d0, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                d0 = (double)this.field_145851_c + 0.5;
                double d2 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d0, (double)this.field_145848_d + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public void func_145836_u() {
    }

    public void toggleVisualization() {
        this.setVisualization(!this.m_visualization);
    }

    public void setVisualization(boolean visualization) {
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        this.m_visualization = visualization;
        this.m_kMin = 0;
        this.m_swapDir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
        switch (this.m_swapDir) {
            default: {
                this.m_iMin = -(this.m_size - 1) / 2;
                this.m_jMin = 1;
                break;
            }
            case 1: {
                this.m_iMin = -this.m_size;
                this.m_jMin = -(this.m_size - 1) / 2;
                break;
            }
            case 2: {
                this.m_iMin = -(this.m_size - 1) / 2;
                this.m_jMin = -this.m_size;
                break;
            }
            case 3: {
                this.m_iMin = 1;
                this.m_jMin = -(this.m_size - 1) / 2;
            }
        }
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                for (int k = 0; k < this.m_size; ++k) {
                    int zOff;
                    int xOff;
                    int yOff = k;
                    switch (this.m_swapDir) {
                        default: {
                            xOff = this.m_size - i - 1;
                            zOff = j;
                            break;
                        }
                        case 1: {
                            xOff = this.m_size - j - 1;
                            zOff = this.m_size - i - 1;
                            break;
                        }
                        case 2: {
                            xOff = i;
                            zOff = this.m_size - j - 1;
                            break;
                        }
                        case 3: {
                            xOff = j;
                            zOff = i;
                        }
                    }
                    int x = this.field_145851_c + this.m_iMin + xOff;
                    int y = this.field_145848_d + this.m_kMin + yOff;
                    int z = this.field_145849_e + this.m_jMin + zOff;
                    TileEntity uncastTileEntity = this.field_145850_b.func_147438_o(x, y, z);
                    GeoChestTileEntity tileEntity = null;
                    if (!(uncastTileEntity instanceof GeoChestTileEntity)) continue;
                    tileEntity = (GeoChestTileEntity)uncastTileEntity;
                    tileEntity.setVisualization(visualization);
                }
            }
        }
        this.m_isSwapping = false;
    }

    public boolean isVisualizationOn() {
        return this.m_visualization;
    }

    public void openChest() {
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
    }

    public void closeChest() {
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void setOriginalDirection(int direction) {
        this.m_swapDir = direction & 3;
        this.m_prevSwapDir = direction & 3;
    }

    public void setCurrentDirection(int direction) {
        this.m_swapDir = direction & 3;
    }

    public int getCurrentDirection() {
        return this.m_swapDir;
    }

    public int getPrevDirection() {
        return this.m_prevSwapDir;
    }

    public int getRelativeDirection() {
        return this.getLocalRotation(this.m_swapDir, this.m_prevSwapDir);
    }

    public boolean isAligned() {
        return this.m_swapDir == this.m_prevSwapDir;
    }

    public void func_145841_b(NBTTagCompound nbtCompound) {
        super.func_145841_b(nbtCompound);
        nbtCompound.func_74774_a("GeoChestSize", (byte)this.m_size);
        nbtCompound.func_74778_a("Name", this.m_name);
        nbtCompound.func_74774_a("SwapDir", (byte)this.m_swapDir);
        nbtCompound.func_74774_a("PrevSwapDir", (byte)this.m_prevSwapDir);
        NBTTagList nbtInventories = nbtCompound.func_150295_c("Inventories", 10);
        nbtCompound.func_74782_a("Inventories", (NBTBase)nbtInventories);
        ArrayList<GeoChestInventory> inventoryList = this.getInventories();
        for (int i = 0; i < inventoryList.size(); ++i) {
            NBTTagCompound nbtInventory = new NBTTagCompound();
            nbtInventory.func_74774_a("Layer", (byte)i);
            NBTTagList nbtitems = nbtInventory.func_150295_c("Items", 10);
            nbtInventory.func_74782_a("Items", (NBTBase)nbtitems);
            GeoChestInventory inventory = inventoryList.get(i);
            for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                NBTTagCompound blockNBT;
                NBTTagCompound geoNBT = new NBTTagCompound();
                geoNBT.func_74774_a("GeochestSlot", (byte)j);
                geoNBT.func_74774_a("GeochestTagType", (byte)0);
                geoNBT.func_74768_a("BlockID", inventory.getBlockIDInSlot(j));
                geoNBT.func_74774_a("Metadata", (byte)(inventory.getMetadataInSlot(j) & 0xFF));
                nbtitems.func_74742_a((NBTBase)geoNBT);
                ItemStack itemStack = inventory.func_70301_a(j);
                if (itemStack != null) {
                    NBTTagCompound nbtSlot = new NBTTagCompound();
                    nbtSlot.func_74774_a("GeochestSlot", (byte)j);
                    nbtSlot.func_74774_a("GeochestTagType", (byte)1);
                    itemStack.func_77955_b(nbtSlot);
                    nbtitems.func_74742_a((NBTBase)nbtSlot);
                }
                if ((blockNBT = inventory.getNBTInSlot(j)) == null) continue;
                blockNBT.func_74774_a("GeochestSlot", (byte)j);
                blockNBT.func_74774_a("GeochestTagType", (byte)2);
                nbtitems.func_74742_a((NBTBase)blockNBT);
            }
            nbtInventories.func_74742_a((NBTBase)nbtInventory);
        }
    }

    public void func_145839_a(NBTTagCompound nbtCompound) {
        if (nbtCompound == null) {
            nbtCompound = new NBTTagCompound();
        }
        if (!nbtCompound.func_74764_b("x")) {
            nbtCompound.func_74768_a("x", this.field_145851_c);
        }
        if (!nbtCompound.func_74764_b("y")) {
            nbtCompound.func_74768_a("y", this.field_145848_d);
        }
        if (!nbtCompound.func_74764_b("z")) {
            nbtCompound.func_74768_a("z", this.field_145849_e);
        }
        super.func_145839_a(nbtCompound);
        this.m_size = nbtCompound.func_74771_c("GeoChestSize");
        this.m_name = nbtCompound.func_74779_i("Name");
        this.m_swapDir = nbtCompound.func_74771_c("SwapDir");
        this.m_prevSwapDir = nbtCompound.func_74771_c("PrevSwapDir");
        NBTTagList nbtInventories = nbtCompound.func_150295_c("Inventories", 10);
        ArrayList<GeoChestInventory> inventoryList = this.getInventories();
        for (int i = 0; i < nbtInventories.func_74745_c(); ++i) {
            int j;
            NBTTagCompound nbtInventory = nbtInventories.func_150305_b(i);
            int layer = nbtInventory.func_74771_c("Layer") & 0xFF;
            NBTTagList nbtItems = nbtInventory.func_150295_c("Items", 10);
            GeoChestInventory inventory = inventoryList.get(i);
            for (j = 0; j < inventory.func_70302_i_(); ++j) {
                inventory.func_70299_a(j, null);
                inventory.setInventorySlotNBT(j, null);
            }
            block7: for (j = 0; j < nbtItems.func_74745_c(); ++j) {
                NBTTagCompound nbtSlot = nbtItems.func_150305_b(j);
                int slot = nbtSlot.func_74771_c("GeochestSlot") & 0xFF;
                int tagType = nbtSlot.func_74771_c("GeochestTagType") & 0xFF;
                switch (tagType) {
                    case 0: {
                        int blockID = nbtSlot.func_74762_e("BlockID");
                        int metadata = nbtSlot.func_74771_c("Metadata") & 0xFF;
                        inventory.setInventoryBlockID(slot, blockID);
                        inventory.setInventoryMetadata(slot, metadata);
                        continue block7;
                    }
                    case 1: {
                        inventory.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)nbtSlot));
                        continue block7;
                    }
                    case 2: {
                        inventory.setInventorySlotNBT(slot, nbtSlot);
                    }
                }
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    private boolean isAttach(int blockID) {
        if (blockID == Block.func_149682_b((Block)Blocks.field_150351_n) || blockID == Block.func_149682_b((Block)Blocks.field_150354_m) || blockID == Block.func_149682_b((Block)Blocks.field_150467_bQ) || blockID == Block.func_149682_b((Block)Blocks.field_150380_bt)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150355_j) || blockID == Block.func_149682_b((Block)Blocks.field_150358_i) || blockID == Block.func_149682_b((Block)Blocks.field_150353_l) || blockID == Block.func_149682_b((Block)Blocks.field_150356_k)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150478_aa) || blockID == Block.func_149682_b((Block)Blocks.field_150429_aA) || blockID == Block.func_149682_b((Block)Blocks.field_150437_az)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150468_ap) || blockID == Block.func_149682_b((Block)Blocks.field_150472_an) || blockID == Block.func_149682_b((Block)Blocks.field_150444_as) || blockID == Block.func_149682_b((Block)Blocks.field_150415_aT) || blockID == Block.func_149682_b((Block)Blocks.field_150466_ao) || blockID == Block.func_149682_b((Block)Blocks.field_150454_av)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150464_aj) || blockID == Block.func_149682_b((Block)Blocks.field_150394_bc) || blockID == Block.func_149682_b((Block)Blocks.field_150393_bb) || blockID == Block.func_149682_b((Block)Blocks.field_150459_bM) || blockID == Block.func_149682_b((Block)Blocks.field_150469_bN)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150434_aF) || blockID == Block.func_149682_b((Block)Blocks.field_150436_aH) || blockID == Block.func_149682_b((Block)Blocks.field_150392_bi) || blockID == Block.func_149682_b((Block)Blocks.field_150345_g) || blockID == Block.func_149682_b((Block)Blocks.field_150330_I) || blockID == Block.func_149682_b((Block)Blocks.field_150375_by) || blockID == Block.func_149682_b((Block)Blocks.field_150395_bd) || blockID == Block.func_149682_b((Block)Blocks.field_150388_bm)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150338_P) || blockID == Block.func_149682_b((Block)Blocks.field_150337_Q) || blockID == Block.func_149682_b((Block)Blocks.field_150328_O) || blockID == Block.func_149682_b((Block)Blocks.field_150327_N) || blockID == Block.func_149682_b((Block)Blocks.field_150398_cm) || blockID == Block.func_149682_b((Block)Blocks.field_150349_c) || blockID == Block.func_149682_b((Block)Blocks.field_150329_H) || blockID == Block.func_149682_b((Block)Blocks.field_150457_bL)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150326_M)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150442_at) || blockID == Block.func_149682_b((Block)Blocks.field_150471_bO) || blockID == Block.func_149682_b((Block)Blocks.field_150430_aB) || blockID == Block.func_149682_b((Block)Blocks.field_150452_aw) || blockID == Block.func_149682_b((Block)Blocks.field_150456_au) || blockID == Block.func_149682_b((Block)Blocks.field_150445_bS) || blockID == Block.func_149682_b((Block)Blocks.field_150443_bT)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150488_af) || blockID == Block.func_149682_b((Block)Blocks.field_150413_aR) || blockID == Block.func_149682_b((Block)Blocks.field_150416_aS) || blockID == Block.func_149682_b((Block)Blocks.field_150441_bU) || blockID == Block.func_149682_b((Block)Blocks.field_150455_bV)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150448_aq) || blockID == Block.func_149682_b((Block)Blocks.field_150318_D) || blockID == Block.func_149682_b((Block)Blocks.field_150408_cc) || blockID == Block.func_149682_b((Block)Blocks.field_150319_E)) {
            return true;
        }
        if (blockID == Block.func_149682_b((Block)Blocks.field_150479_bC) || blockID == Block.func_149682_b((Block)Blocks.field_150473_bD)) {
            return true;
        }
        return blockID == Block.func_149682_b((Block)Blocks.field_150404_cg) || blockID == Block.func_149682_b((Block)Blocks.field_150433_aE) || blockID == Block.func_149682_b((Block)Blocks.field_150480_ab) || blockID == Block.func_149682_b((Block)Blocks.field_150427_aO) || blockID == Block.func_149682_b((Block)Blocks.field_150384_bq);
    }

    private int localizeRotation(int blockID, int metadata, int parentRotation) {
        boolean applyGeneralRotation = false;
        if (blockID == Block.func_149682_b((Block)ModGeoChests.tinyGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.smallGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.mediumGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.largeGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.hugeGeochest)) {
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150478_aa) || blockID == Block.func_149682_b((Block)Blocks.field_150429_aA) || blockID == Block.func_149682_b((Block)Blocks.field_150437_az)) {
            metadata = this.torchToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150468_ap) || blockID == Block.func_149682_b((Block)Blocks.field_150444_as) || blockID == Block.func_149682_b((Block)Blocks.field_150460_al) || blockID == Block.func_149682_b((Block)Blocks.field_150470_am) || blockID == Block.func_149682_b((Block)Blocks.field_150486_ae) || blockID == Block.func_149682_b((Block)Blocks.field_150477_bB) || blockID == Block.func_149682_b((Block)Blocks.field_150447_bR)) {
            metadata = this.ladderToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150367_z) || blockID == Block.func_149682_b((Block)Blocks.field_150409_cd) || blockID == Block.func_149682_b((Block)Blocks.field_150438_bZ)) {
            metadata = this.dispenserToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150472_an)) {
            metadata = this.signPostToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150389_bf) || blockID == Block.func_149682_b((Block)Blocks.field_150446_ar) || blockID == Block.func_149682_b((Block)Blocks.field_150387_bl) || blockID == Block.func_149682_b((Block)Blocks.field_150370_cb) || blockID == Block.func_149682_b((Block)Blocks.field_150372_bz) || blockID == Block.func_149682_b((Block)Blocks.field_150390_bg) || blockID == Block.func_149682_b((Block)Blocks.field_150487_bG) || blockID == Block.func_149682_b((Block)Blocks.field_150481_bH) || blockID == Block.func_149682_b((Block)Blocks.field_150476_ad) || blockID == Block.func_149682_b((Block)Blocks.field_150485_bF) || blockID == Block.func_149682_b((Block)Blocks.field_150400_ck) || blockID == Block.func_149682_b((Block)Blocks.field_150401_cl)) {
            metadata = this.stairsToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150471_bO) || blockID == Block.func_149682_b((Block)Blocks.field_150430_aB)) {
            metadata = this.buttonToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150364_r) || blockID == Block.func_149682_b((Block)Blocks.field_150363_s) || blockID == Block.func_149682_b((Block)Blocks.field_150407_cf)) {
            metadata = this.getLocalWoodRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150371_ca)) {
            metadata = this.getLocalPillarRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150427_aO)) {
            metadata = this.getLocalPortalRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150423_aK) || blockID == Block.func_149682_b((Block)Blocks.field_150428_aP) || blockID == Block.func_149682_b((Block)Blocks.field_150396_be) || blockID == Block.func_149682_b((Block)Blocks.field_150378_br) || blockID == Block.func_149682_b((Block)Blocks.field_150479_bC)) {
            metadata = this.pumpkinToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150324_C)) {
            metadata = this.pumpkinToGeoRotation(metadata);
            metadata &= 0xFFFFFFFB;
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150415_aT)) {
            metadata = this.trapdoorToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150466_ao) || blockID == Block.func_149682_b((Block)Blocks.field_150454_av)) {
            metadata = this.getLocalDoorRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150442_at)) {
            metadata = this.getLocalLeverRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150420_aW) || blockID == Block.func_149682_b((Block)Blocks.field_150419_aX)) {
            metadata = this.getLocalHugeMushroomRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150331_J) || blockID == Block.func_149682_b((Block)Blocks.field_150320_F) || blockID == Block.func_149682_b((Block)Blocks.field_150326_M)) {
            metadata = this.getLocalPistonRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150413_aR) || blockID == Block.func_149682_b((Block)Blocks.field_150416_aS) || blockID == Block.func_149682_b((Block)Blocks.field_150441_bU) || blockID == Block.func_149682_b((Block)Blocks.field_150455_bV) || blockID == Block.func_149682_b((Block)Blocks.field_150375_by)) {
            metadata = this.redstoneRepeaterToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150467_bQ)) {
            metadata = this.anvilToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150448_aq)) {
            metadata = this.railToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150318_D) || blockID == Block.func_149682_b((Block)Blocks.field_150408_cc) || blockID == Block.func_149682_b((Block)Blocks.field_150319_E)) {
            metadata = this.poweredRailToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150465_bP)) {
            metadata = this.headToGeoRotation(metadata);
            applyGeneralRotation = true;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150395_bd)) {
            metadata = this.getLocalVineRotation(parentRotation, metadata);
            applyGeneralRotation = false;
        }
        if (applyGeneralRotation) {
            int localRotation = this.getLocalRotation(parentRotation, metadata & 3);
            return metadata & 0xFFFFFFFC | localRotation;
        }
        return metadata;
    }

    private int globalizeRotation(int blockID, int metadata, int parentRotation) {
        int globalRotation = this.getGlobalRotation(parentRotation, metadata & 3);
        if (blockID == Block.func_149682_b((Block)ModGeoChests.tinyGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.smallGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.mediumGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.largeGeochest) || blockID == Block.func_149682_b((Block)ModGeoChests.hugeGeochest)) {
            metadata = metadata & 0xFFFFFFFC | globalRotation;
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150478_aa) || blockID == Block.func_149682_b((Block)Blocks.field_150429_aA) || blockID == Block.func_149682_b((Block)Blocks.field_150437_az)) {
            metadata = this.geoToTorchRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150468_ap) || blockID == Block.func_149682_b((Block)Blocks.field_150444_as) || blockID == Block.func_149682_b((Block)Blocks.field_150460_al) || blockID == Block.func_149682_b((Block)Blocks.field_150470_am) || blockID == Block.func_149682_b((Block)Blocks.field_150486_ae) || blockID == Block.func_149682_b((Block)Blocks.field_150477_bB) || blockID == Block.func_149682_b((Block)Blocks.field_150447_bR)) {
            metadata = this.geoToLadderRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150367_z) || blockID == Block.func_149682_b((Block)Blocks.field_150409_cd) || blockID == Block.func_149682_b((Block)Blocks.field_150438_bZ)) {
            metadata = this.geoToDispenserRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150472_an)) {
            metadata = this.geoToSignPostRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150389_bf) || blockID == Block.func_149682_b((Block)Blocks.field_150446_ar) || blockID == Block.func_149682_b((Block)Blocks.field_150387_bl) || blockID == Block.func_149682_b((Block)Blocks.field_150370_cb) || blockID == Block.func_149682_b((Block)Blocks.field_150372_bz) || blockID == Block.func_149682_b((Block)Blocks.field_150390_bg) || blockID == Block.func_149682_b((Block)Blocks.field_150487_bG) || blockID == Block.func_149682_b((Block)Blocks.field_150481_bH) || blockID == Block.func_149682_b((Block)Blocks.field_150476_ad) || blockID == Block.func_149682_b((Block)Blocks.field_150485_bF) || blockID == Block.func_149682_b((Block)Blocks.field_150400_ck) || blockID == Block.func_149682_b((Block)Blocks.field_150401_cl)) {
            metadata = this.geoToStairsRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150471_bO) || blockID == Block.func_149682_b((Block)Blocks.field_150430_aB)) {
            metadata = this.geoToButtonRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150364_r) || blockID == Block.func_149682_b((Block)Blocks.field_150363_s) || blockID == Block.func_149682_b((Block)Blocks.field_150407_cf)) {
            metadata = this.getGlobalWoodRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150371_ca)) {
            metadata = this.getGlobalPillarRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150427_aO)) {
            metadata = this.getGlobalPortalRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150423_aK) || blockID == Block.func_149682_b((Block)Blocks.field_150428_aP) || blockID == Block.func_149682_b((Block)Blocks.field_150396_be) || blockID == Block.func_149682_b((Block)Blocks.field_150378_br) || blockID == Block.func_149682_b((Block)Blocks.field_150479_bC)) {
            metadata = this.geoToPumpkinRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150324_C)) {
            metadata = this.geoToPumpkinRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150415_aT)) {
            metadata = this.geoToTrapdoorRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150466_ao) || blockID == Block.func_149682_b((Block)Blocks.field_150454_av)) {
            metadata = this.getGlobalDoorRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150442_at)) {
            metadata = this.getGlobalLeverRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150420_aW) || blockID == Block.func_149682_b((Block)Blocks.field_150419_aX)) {
            metadata = this.getGlobalHugeMushroomRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150331_J) || blockID == Block.func_149682_b((Block)Blocks.field_150320_F) || blockID == Block.func_149682_b((Block)Blocks.field_150326_M)) {
            metadata = this.getGlobalPistonRotation(parentRotation, metadata);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150413_aR) || blockID == Block.func_149682_b((Block)Blocks.field_150416_aS) || blockID == Block.func_149682_b((Block)Blocks.field_150441_bU) || blockID == Block.func_149682_b((Block)Blocks.field_150455_bV) || blockID == Block.func_149682_b((Block)Blocks.field_150375_by)) {
            metadata = this.geoToRedstoneRepeaterRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150467_bQ)) {
            metadata = this.geoToAnvilRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150448_aq)) {
            metadata = this.geoToRailRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150318_D) || blockID == Block.func_149682_b((Block)Blocks.field_150408_cc) || blockID == Block.func_149682_b((Block)Blocks.field_150319_E)) {
            metadata = this.geoToPoweredRailRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150465_bP)) {
            metadata = this.geoToHeadRotation(metadata & 0xFFFFFFFC | globalRotation);
        } else if (blockID == Block.func_149682_b((Block)Blocks.field_150395_bd)) {
            metadata = this.getGlobalVineRotation(parentRotation, metadata);
        }
        return metadata;
    }

    public boolean ContainsUnknownBlocks() {
        this.m_kMin = 0;
        this.m_swapDir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
        switch (this.m_swapDir) {
            default: {
                this.m_iMin = -(this.m_size - 1) / 2;
                this.m_jMin = 1;
                break;
            }
            case 1: {
                this.m_iMin = -this.m_size;
                this.m_jMin = -(this.m_size - 1) / 2;
                break;
            }
            case 2: {
                this.m_iMin = -(this.m_size - 1) / 2;
                this.m_jMin = -this.m_size;
                break;
            }
            case 3: {
                this.m_iMin = 1;
                this.m_jMin = -(this.m_size - 1) / 2;
            }
        }
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                for (int k = 0; k < this.m_size; ++k) {
                    int x = this.field_145851_c + this.m_iMin + i;
                    int y = this.field_145848_d + this.m_kMin + k;
                    int z = this.field_145849_e + this.m_jMin + j;
                    TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
                    if (tileEntity == null) continue;
                    if (tileEntity instanceof GeoChestTileEntity) {
                        GeoChestTileEntity geoChestTileEntity = (GeoChestTileEntity)tileEntity;
                        if (!geoChestTileEntity.ContainsUnknownBlocks()) continue;
                        return true;
                    }
                    if (tileEntity.getClass().getName().startsWith("net.minecraft.tileentity")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void swap(int swapType, EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ArrayList<Range3D> exclude = new ArrayList<Range3D>();
        this.calculateBlocksToSwap(swapType, exclude, true);
        this.clearSwapData();
        if (this.m_swapResult != 0) {
            ChatComponentText msg = null;
            switch (this.m_swapResult) {
                case 1: {
                    msg = new ChatComponentText("Too many chests to swap!  Max = ");
                    msg.func_150258_a(Integer.valueOf(ModGeoChests.MAX_CHESTS_IN_CHAIN).toString());
                    break;
                }
                case 2: {
                    msg = new ChatComponentText("Too many blocks to swap!  Max = ");
                    msg.func_150258_a(Integer.valueOf(ModGeoChests.MAX_BLOCKS_IN_CHAIN).toString());
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    msg = new ChatComponentText("Too large an area to swap!  Max = ");
                    String sizeString = Integer.valueOf(ModGeoChests.MAX_SIZE_IN_CHAIN).toString();
                    msg.func_150258_a(sizeString + "x" + sizeString + "x" + sizeString);
                    break;
                }
                case 6: {
                    msg = new ChatComponentText("Too complex to swap!  Max = ");
                    String nbtString = Integer.valueOf(ModGeoChests.MAX_NBT_IN_CHAIN).toString();
                    msg.func_150258_a(nbtString + " bytes");
                    break;
                }
                default: {
                    msg = new ChatComponentText("Cannot swap!  Unknown error.");
                }
            }
            if (player != null) {
                player.func_145747_a((IChatComponent)msg);
            }
            return;
        }
        exclude = new ArrayList();
        this.calculateBlocksToSwap(swapType, exclude, false);
        this.clearBlocksSwappingIn();
        this.addNonAttachBlocksSwappingOut();
        this.addAttachBlocksSwappingOut();
        this.populateInventory();
        this.forceUpdateAffectedRegion(false);
        this.m_prevSwapDir = this.m_swapDir;
    }

    private ChainInfo calculateSwapChainIn(int swapType, ArrayList<Range3D> exclude, boolean scanOnly) {
        this.calculateBlocksToSwap(swapType, exclude, scanOnly);
        this.m_childExclude.add(new Range3D(this.field_145851_c + this.m_iMin, this.field_145848_d + this.m_kMin, this.field_145849_e + this.m_jMin, this.field_145851_c + this.m_iMin + this.m_size - 1, this.field_145848_d + this.m_kMin + this.m_size - 1, this.field_145849_e + this.m_jMin + this.m_size - 1));
        this.m_childExclude.add(new Range3D(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.m_chainInfo.m_childExclude = this.m_childExclude;
        return this.m_chainInfo;
    }

    private void swapChainIn() {
        this.clearBlocksSwappingIn();
        this.addNonAttachBlocksSwappingOut();
        this.addAttachBlocksSwappingOut();
        this.populateInventory();
    }

    private ChainInfo swapChainOutNonAttach(int swapType, ArrayList<Range3D> exclude) {
        this.calculateBlocksToSwap(swapType, exclude, false);
        this.clearBlocksSwappingIn();
        this.addNonAttachBlocksSwappingOut();
        this.m_childExclude.add(new Range3D(this.field_145851_c + this.m_iMin, this.field_145848_d + this.m_kMin, this.field_145849_e + this.m_jMin, this.field_145851_c + this.m_iMin + this.m_size - 1, this.field_145848_d + this.m_kMin + this.m_size - 1, this.field_145849_e + this.m_jMin + this.m_size - 1));
        this.m_childExclude.add(new Range3D(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.m_chainInfo.m_childExclude = this.m_childExclude;
        return this.m_chainInfo;
    }

    private void swapChainOutAttach() {
        this.addAttachBlocksSwappingOut();
        this.populateInventory();
    }

    private void calculateBlocksToSwap(int swapType, ArrayList<Range3D> exclude, boolean scanOnly) {
        int zOff;
        int xOff;
        int yOff;
        int k;
        int j;
        int i;
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        this.m_swapResult = 0;
        GeoChest geoChest = (GeoChest)this.field_145854_h;
        this.m_swapType = swapType;
        this.m_exclude = exclude;
        this.m_childExclude = new ArrayList();
        this.m_chainInfo = null;
        this.m_itemStacksTemp = new ArrayList();
        this.m_itemNBTTemp = new ArrayList();
        this.m_itemBlockID = new ArrayList();
        this.m_itemMetadata = new ArrayList();
        this.m_pointsInTemp = new ArrayList();
        this.m_pointsOutTemp = new ArrayList();
        this.m_geoChestsChainIn = new ArrayList();
        this.m_geoChestsChainOut = new ArrayList();
        this.m_kMin = 0;
        this.m_swapDir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
        switch (this.m_swapDir) {
            default: {
                this.m_iMin = -(this.m_size - 1) / 2;
                this.m_jMin = 1;
                break;
            }
            case 1: {
                this.m_iMin = -this.m_size;
                this.m_jMin = -(this.m_size - 1) / 2;
                break;
            }
            case 2: {
                this.m_iMin = -(this.m_size - 1) / 2;
                this.m_jMin = -this.m_size;
                break;
            }
            case 3: {
                this.m_iMin = 1;
                this.m_jMin = -(this.m_size - 1) / 2;
            }
        }
        for (i = 0; i < this.m_size; ++i) {
            for (j = 0; j < this.m_size; ++j) {
                for (k = 0; k < this.m_size; ++k) {
                    yOff = k;
                    switch (this.m_swapDir) {
                        default: {
                            xOff = this.m_size - i - 1;
                            zOff = j;
                            break;
                        }
                        case 1: {
                            xOff = this.m_size - j - 1;
                            zOff = this.m_size - i - 1;
                            break;
                        }
                        case 2: {
                            xOff = i;
                            zOff = this.m_size - j - 1;
                            break;
                        }
                        case 3: {
                            xOff = j;
                            zOff = i;
                        }
                    }
                    int x = this.field_145851_c + this.m_iMin + xOff;
                    int y = this.field_145848_d + this.m_kMin + yOff;
                    int z = this.field_145849_e + this.m_jMin + zOff;
                    TileEntity uncastTileEntity = this.field_145850_b.func_147438_o(x, y, z);
                    GeoChestTileEntity tileEntity = null;
                    if (!(uncastTileEntity instanceof GeoChestTileEntity)) continue;
                    boolean excluded = false;
                    for (int e = 0; e < exclude.size(); ++e) {
                        if (!exclude.get(e).inRange(x, y, z)) continue;
                        excluded = true;
                        break;
                    }
                    if (excluded) continue;
                    tileEntity = (GeoChestTileEntity)uncastTileEntity;
                    ArrayList<Range3D> subexclude = new ArrayList<Range3D>();
                    subexclude.addAll(exclude);
                    subexclude.addAll(this.m_childExclude);
                    subexclude.add(new Range3D(this.field_145851_c + this.m_iMin, this.field_145848_d + this.m_kMin, this.field_145849_e + this.m_jMin, this.field_145851_c + this.m_iMin + this.m_size - 1, this.field_145848_d + this.m_kMin + this.m_size - 1, this.field_145849_e + this.m_jMin + this.m_size - 1));
                    subexclude.add(new Range3D(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e));
                    ChainInfo subChainInfo = tileEntity.calculateSwapChainIn(swapType, subexclude, scanOnly);
                    if (!scanOnly) {
                        tileEntity.swapChainIn();
                    }
                    this.m_childExclude.addAll(subChainInfo.m_childExclude);
                    if (this.m_chainInfo == null) {
                        this.m_chainInfo = subChainInfo;
                    } else {
                        this.m_swapResult = this.m_chainInfo.addChain(subChainInfo);
                    }
                    this.m_geoChestsChainIn.add(tileEntity);
                }
            }
        }
        int nbtSize = 0;
        for (i = 0; i < this.m_size; ++i) {
            for (j = 0; j < this.m_size; ++j) {
                for (k = 0; k < this.m_size; ++k) {
                    yOff = k;
                    switch (this.m_swapDir) {
                        default: {
                            xOff = this.m_size - i - 1;
                            zOff = j;
                            break;
                        }
                        case 1: {
                            xOff = this.m_size - j - 1;
                            zOff = this.m_size - i - 1;
                            break;
                        }
                        case 2: {
                            xOff = i;
                            zOff = this.m_size - j - 1;
                            break;
                        }
                        case 3: {
                            xOff = j;
                            zOff = i;
                        }
                    }
                    int x = this.field_145851_c + this.m_iMin + xOff;
                    int y = this.field_145848_d + this.m_kMin + yOff;
                    int z = this.field_145849_e + this.m_jMin + zOff;
                    boolean excluded = false;
                    for (int e = 0; e < exclude.size(); ++e) {
                        if (!exclude.get(e).inRange(x, y, z)) continue;
                        excluded = true;
                        break;
                    }
                    if (excluded) continue;
                    ItemStack oldStack = this.getFromInventory(i, this.m_size - j - 1, k);
                    int blockID = Block.func_149682_b((Block)this.field_145850_b.func_147439_a(x, y, z));
                    int itemMetadata = this.localizeRotation(blockID, this.field_145850_b.func_72805_g(x, y, z), this.m_swapDir);
                    boolean in = false;
                    boolean out = false;
                    if (blockID != Block.func_149682_b((Block)Blocks.field_150357_h)) {
                        switch (swapType) {
                            default: {
                                in = true;
                                out = true;
                                break;
                            }
                            case 2: {
                                if (blockID <= 0 || oldStack == null || Item.func_150891_b((Item)oldStack.func_77973_b()) <= 0) break;
                                in = true;
                                out = true;
                                break;
                            }
                            case 3: {
                                if (oldStack != null && Item.func_150891_b((Item)oldStack.func_77973_b()) != 0 && Item.func_150891_b((Item)oldStack.func_77973_b()) != Block.func_149682_b((Block)ModGeoChests.geoditeBlock)) break;
                                in = true;
                                break;
                            }
                            case 4: {
                                if (blockID != 0 && blockID != Block.func_149682_b((Block)ModGeoChests.geoditeBlock)) break;
                                out = true;
                            }
                        }
                    }
                    if (in) {
                        ItemStack itemStack;
                        block44: {
                            if (blockID == Block.func_149682_b((Block)Blocks.field_150398_cm) && (itemMetadata & 8) == 8 && k == 0) {
                                blockID = Block.func_149682_b((Block)Blocks.field_150350_a);
                                itemMetadata = 0;
                            }
                            itemStack = null;
                            this.m_itemBlockID.add(blockID);
                            this.m_itemMetadata.add(itemMetadata);
                            try {
                                int itemID;
                                Block block;
                                if (blockID <= 0 || (itemStack = new ItemStack(Block.func_149729_e((int)blockID), 1, itemMetadata)).func_77973_b() != null || (block = Block.func_149729_e((int)blockID)) == null || (itemID = Item.func_150891_b((Item)block.func_149650_a(this.field_145850_b.func_72805_g(x, y, z), this.field_145850_b.field_73012_v, 0))) <= 0) break block44;
                                itemStack = new ItemStack(Item.func_150899_d((int)itemID), 1, itemMetadata);
                            }
                            catch (Exception error) {
                                continue;
                            }
                        }
                        this.m_itemStacksTemp.add(itemStack);
                        NBTTagCompound nbtTag = null;
                        try {
                            TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
                            if (tileEntity != null) {
                                nbtTag = new NBTTagCompound();
                                tileEntity.func_145841_b(nbtTag);
                                if (!nbtTag.func_82582_d() && !scanOnly) {
                                    NBTTagCompound nbtTagBlank = new NBTTagCompound();
                                    tileEntity.func_145839_a(nbtTagBlank);
                                }
                            }
                        }
                        catch (Exception error) {
                            // empty catch block
                        }
                        if (nbtTag != null) {
                            String nbtAsString = nbtTag.toString();
                            nbtSize += nbtAsString.length();
                        }
                        this.m_itemNBTTemp.add(nbtTag);
                        this.m_pointsInTemp.add(new Point3D(i, k, j, in, out));
                    }
                    if (!out || oldStack == null) continue;
                    this.m_pointsOutTemp.add(new Point3D(i, k, j, in, out));
                    if (in) continue;
                    this.m_itemStacksTemp.add(null);
                    this.m_itemNBTTemp.add(null);
                    this.m_itemBlockID.add(0);
                    this.m_itemMetadata.add(0);
                    this.m_pointsInTemp.add(new Point3D(i, k, j, in, out));
                }
            }
        }
        Range3D range = new Range3D(this.field_145851_c + this.m_iMin, this.field_145848_d + this.m_kMin, this.field_145849_e + this.m_jMin, this.field_145851_c + this.m_iMin + this.m_size - 1, this.field_145848_d + this.m_kMin + this.m_size - 1, this.field_145849_e + this.m_jMin + this.m_size - 1);
        ChainInfo chainInfo = new ChainInfo(range, this.m_itemStacksTemp.size(), nbtSize);
        if (this.m_chainInfo == null) {
            this.m_chainInfo = chainInfo;
        } else {
            this.m_swapResult = this.m_chainInfo.addChain(chainInfo);
        }
        this.m_isSwapping = false;
    }

    private void clearBlocksSwappingIn() {
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        for (int m = 0; m < 2; ++m) {
            for (int n = 0; n < this.m_pointsInTemp.size(); ++n) {
                int blockID;
                int zOff;
                int xOff;
                int k;
                Point3D point = this.m_pointsInTemp.get(n);
                int i = point.m_x;
                int j = point.m_z;
                int yOff = k = point.m_y;
                switch (this.m_swapDir) {
                    default: {
                        xOff = this.m_size - i - 1;
                        zOff = j;
                        break;
                    }
                    case 1: {
                        xOff = this.m_size - j - 1;
                        zOff = this.m_size - i - 1;
                        break;
                    }
                    case 2: {
                        xOff = i;
                        zOff = this.m_size - j - 1;
                        break;
                    }
                    case 3: {
                        xOff = j;
                        zOff = i;
                    }
                }
                int x = this.field_145851_c + this.m_iMin + xOff;
                int y = this.field_145848_d + this.m_kMin + yOff;
                int z = this.field_145849_e + this.m_jMin + zOff;
                if (!point.m_in || (blockID = Block.func_149682_b((Block)this.field_145850_b.func_147439_a(x, y, z))) <= 0 || m == 0 && !this.isAttach(blockID) || m == 1 && this.isAttach(blockID)) continue;
                try {
                    this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                    continue;
                }
                catch (Exception error) {
                    this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 7);
                }
            }
        }
        this.m_isSwapping = false;
    }

    private void addNonAttachBlocksSwappingOut() {
        int n;
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        for (n = 0; n < this.m_pointsOutTemp.size(); ++n) {
            int oldBlockID;
            int zOff;
            int xOff;
            int k;
            Point3D point = this.m_pointsOutTemp.get(n);
            int i = point.m_x;
            int j = point.m_z;
            int yOff = k = point.m_y;
            switch (this.m_swapDir) {
                default: {
                    xOff = this.m_size - i - 1;
                    zOff = j;
                    break;
                }
                case 1: {
                    xOff = this.m_size - j - 1;
                    zOff = this.m_size - i - 1;
                    break;
                }
                case 2: {
                    xOff = i;
                    zOff = this.m_size - j - 1;
                    break;
                }
                case 3: {
                    xOff = j;
                    zOff = i;
                }
            }
            int x = this.field_145851_c + this.m_iMin + xOff;
            int y = this.field_145848_d + this.m_kMin + yOff;
            int z = this.field_145849_e + this.m_jMin + zOff;
            if (this.m_swapType == 4 && (oldBlockID = Block.func_149682_b((Block)this.field_145850_b.func_147439_a(x, y, z))) == Block.func_149682_b((Block)ModGeoChests.geoditeBlock)) continue;
            NBTTagCompound oldNBT = this.getNBTFromInventory(i, this.m_size - j - 1, k);
            int oldBlockID2 = this.getBlockIDFromInventory(i, this.m_size - j - 1, k);
            int oldMetadata = this.getMetadataFromInventory(i, this.m_size - j - 1, k);
            if (!point.m_out || oldBlockID2 <= 0 || this.isAttach(oldBlockID2)) continue;
            int itemMetadata = this.globalizeRotation(oldBlockID2, oldMetadata, this.m_swapDir);
            this.field_145850_b.func_147465_d(x, y, z, Block.func_149729_e((int)oldBlockID2), itemMetadata, 2);
            TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
            if (tileEntity instanceof GeoChestTileEntity) {
                this.m_geoChestsChainOut.add((GeoChestTileEntity)tileEntity);
            }
            if (oldNBT != null && !oldNBT.func_82582_d()) {
                oldNBT.func_74768_a("x", x);
                oldNBT.func_74768_a("y", y);
                oldNBT.func_74768_a("z", z);
                if (tileEntity != null) {
                    tileEntity.func_145839_a(oldNBT);
                }
            }
            this.field_145850_b.func_72921_c(x, y, z, itemMetadata, 7);
        }
        for (n = 0; n < this.m_geoChestsChainOut.size(); ++n) {
            ArrayList<Range3D> subexclude = new ArrayList<Range3D>();
            subexclude.addAll(this.m_exclude);
            subexclude.addAll(this.m_childExclude);
            subexclude.add(new Range3D(this.field_145851_c + this.m_iMin, this.field_145848_d + this.m_kMin, this.field_145849_e + this.m_jMin, this.field_145851_c + this.m_iMin + this.m_size - 1, this.field_145848_d + this.m_kMin + this.m_size - 1, this.field_145849_e + this.m_jMin + this.m_size - 1));
            subexclude.add(new Range3D(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            GeoChestTileEntity tileEntity = this.m_geoChestsChainOut.get(n);
            ChainInfo subChainInfo = tileEntity.swapChainOutNonAttach(this.m_swapType, subexclude);
            this.m_childExclude.addAll(subChainInfo.m_childExclude);
            this.m_chainInfo.addChain(subChainInfo);
        }
        this.m_isSwapping = false;
    }

    private void addAttachBlocksSwappingOut() {
        int n;
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        for (n = 0; n < this.m_pointsOutTemp.size(); ++n) {
            int oldBlockID;
            int zOff;
            int xOff;
            int k;
            Point3D point = this.m_pointsOutTemp.get(n);
            int i = point.m_x;
            int j = point.m_z;
            int yOff = k = point.m_y;
            switch (this.m_swapDir) {
                default: {
                    xOff = this.m_size - i - 1;
                    zOff = j;
                    break;
                }
                case 1: {
                    xOff = this.m_size - j - 1;
                    zOff = this.m_size - i - 1;
                    break;
                }
                case 2: {
                    xOff = i;
                    zOff = this.m_size - j - 1;
                    break;
                }
                case 3: {
                    xOff = j;
                    zOff = i;
                }
            }
            int x = this.field_145851_c + this.m_iMin + xOff;
            int y = this.field_145848_d + this.m_kMin + yOff;
            int z = this.field_145849_e + this.m_jMin + zOff;
            if (this.m_swapType == 4 && (oldBlockID = Block.func_149682_b((Block)this.field_145850_b.func_147439_a(x, y, z))) == Block.func_149682_b((Block)ModGeoChests.geoditeBlock)) continue;
            NBTTagCompound oldNBT = this.getNBTFromInventory(i, this.m_size - j - 1, k);
            int oldBlockID2 = this.getBlockIDFromInventory(i, this.m_size - j - 1, k);
            int oldMetadata = this.getMetadataFromInventory(i, this.m_size - j - 1, k);
            if (!point.m_out || oldBlockID2 <= 0 || !this.isAttach(oldBlockID2)) continue;
            int itemMetadata = this.globalizeRotation(oldBlockID2, oldMetadata, this.m_swapDir);
            this.field_145850_b.func_147465_d(x, y, z, Block.func_149729_e((int)oldBlockID2), itemMetadata, 2);
            TileEntity tileEntity = this.field_145850_b.func_147438_o(x, y, z);
            if (tileEntity instanceof GeoChestTileEntity) {
                this.m_geoChestsChainOut.add((GeoChestTileEntity)tileEntity);
            }
            if (oldNBT != null && !oldNBT.func_82582_d()) {
                oldNBT.func_74768_a("x", x);
                oldNBT.func_74768_a("y", y);
                oldNBT.func_74768_a("z", z);
                if (tileEntity != null) {
                    tileEntity.func_145839_a(oldNBT);
                }
            }
            this.field_145850_b.func_72921_c(x, y, z, itemMetadata, 7);
        }
        for (n = 0; n < this.m_geoChestsChainOut.size(); ++n) {
            GeoChestTileEntity tileEntity = this.m_geoChestsChainOut.get(n);
            tileEntity.swapChainOutAttach();
        }
        this.m_isSwapping = false;
    }

    private void populateInventory() {
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        for (int n = 0; n < this.m_pointsInTemp.size(); ++n) {
            ItemStack oldStack;
            Point3D point = this.m_pointsInTemp.get(n);
            int i = point.m_x;
            int j = point.m_z;
            int k = point.m_y;
            if (this.m_swapType == 3 && (oldStack = this.getFromInventory(i, this.m_size - j - 1, k)) != null && Item.func_150891_b((Item)oldStack.func_77973_b()) == Block.func_149682_b((Block)ModGeoChests.geoditeBlock)) continue;
            ItemStack itemStack = this.m_itemStacksTemp.get(n);
            NBTTagCompound nbtTag = this.m_itemNBTTemp.get(n);
            int blockID = this.m_itemBlockID.get(n);
            int metadata = this.m_itemMetadata.get(n);
            if (itemStack != null) {
                // empty if block
            }
            this.putInInventory(i, this.m_size - j - 1, k, blockID, metadata, itemStack, nbtTag);
        }
        NBTTagCompound temp = new NBTTagCompound();
        this.func_145841_b(temp);
        this.func_145839_a(temp);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        this.m_isSwapping = false;
    }

    private void forceUpdateAffectedRegion(boolean isChained) {
        int n;
        if (this.m_isSwapping) {
            return;
        }
        this.m_isSwapping = true;
        for (int i = -1; i <= this.m_size; ++i) {
            for (int j = -1; j <= this.m_size; ++j) {
                for (int k = -1; k <= this.m_size; ++k) {
                    int x = this.field_145851_c + this.m_iMin + i;
                    int y = this.field_145848_d + this.m_kMin + k;
                    int z = this.field_145849_e + this.m_jMin + j;
                    this.field_145850_b.func_147444_c(x, y, z, this.field_145850_b.func_147439_a(x, y, z));
                    this.field_145850_b.func_147459_d(x, y, z, this.field_145850_b.func_147439_a(x, y, z));
                }
            }
        }
        for (n = 0; n < this.m_geoChestsChainIn.size(); ++n) {
            this.m_geoChestsChainIn.get(n).forceUpdateAffectedRegion(true);
        }
        for (n = 0; n < this.m_geoChestsChainOut.size(); ++n) {
            this.m_geoChestsChainOut.get(n).forceUpdateAffectedRegion(true);
        }
        if (!isChained) {
            // empty if block
        }
        this.clearSwapData();
    }

    public void clearSwapData() {
        this.m_itemStacksTemp.clear();
        this.m_itemNBTTemp.clear();
        this.m_itemBlockID.clear();
        this.m_itemMetadata.clear();
        this.m_pointsInTemp.clear();
        this.m_pointsOutTemp.clear();
        this.m_geoChestsChainIn.clear();
        this.m_geoChestsChainOut.clear();
        this.m_chainInfo = null;
        this.m_isSwapping = false;
    }

    private int torchToGeoRotation(int metadata) {
        if (metadata == 0) {
            return 4;
        }
        switch (metadata) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return metadata;
    }

    private int geoToTorchRotation(int metadata) {
        if ((metadata & 4) != 0) {
            return 0;
        }
        switch (metadata) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return metadata;
    }

    private int ladderToGeoRotation(int metadata) {
        switch (metadata) {
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 1;
            }
        }
        return metadata;
    }

    private int geoToLadderRotation(int metadata) {
        switch (metadata) {
            case 0: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 1: {
                return 5;
            }
        }
        return metadata;
    }

    private int dispenserToGeoRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 0: {
                return 4 | extra;
            }
            case 1: {
                return 5 | extra;
            }
            case 2: {
                return 0 | extra;
            }
            case 3: {
                return 2 | extra;
            }
            case 4: {
                return 3 | extra;
            }
            case 5: {
                return 1 | extra;
            }
        }
        return metadata;
    }

    private int geoToDispenserRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 0: {
                return 2 | extra;
            }
            case 2: {
                return 3 | extra;
            }
            case 3: {
                return 4 | extra;
            }
            case 1: {
                return 5 | extra;
            }
            case 4: {
                return 0 | extra;
            }
            case 5: {
                return 1 | extra;
            }
        }
        return metadata;
    }

    private int signPostToGeoRotation(int metadata) {
        int dir = 0;
        switch (metadata / 4) {
            case 0: {
                dir = 2;
                break;
            }
            case 1: {
                dir = 3;
                break;
            }
            case 2: {
                dir = 0;
                break;
            }
            case 3: {
                dir = 1;
            }
        }
        int offset = metadata % 4 << 2;
        return dir | offset;
    }

    private int geoToSignPostRotation(int metadata) {
        int dir = metadata & 3;
        int offset = (metadata & 0xFFFFFFFC) >> 2;
        switch (dir) {
            case 2: {
                return 0 + offset;
            }
            case 3: {
                return 4 + offset;
            }
            case 0: {
                return 8 + offset;
            }
            case 1: {
                return 12 + offset;
            }
        }
        return metadata;
    }

    private int stairsToGeoRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 0: {
                return 1 | extra;
            }
            case 1: {
                return 3 | extra;
            }
            case 2: {
                return 2 | extra;
            }
            case 3: {
                return 0 | extra;
            }
        }
        return metadata;
    }

    private int geoToStairsRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 1: {
                return 0 | extra;
            }
            case 3: {
                return 1 | extra;
            }
            case 2: {
                return 2 | extra;
            }
            case 0: {
                return 3 | extra;
            }
        }
        return metadata;
    }

    private int buttonToGeoRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 1: {
                return 1 | extra;
            }
            case 2: {
                return 3 | extra;
            }
            case 3: {
                return 2 | extra;
            }
            case 4: {
                return 0 | extra;
            }
        }
        return metadata;
    }

    private int geoToButtonRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 1: {
                return 1 | extra;
            }
            case 3: {
                return 2 | extra;
            }
            case 2: {
                return 3 | extra;
            }
            case 0: {
                return 4 | extra;
            }
        }
        return metadata;
    }

    private int pumpkinToGeoRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 0: {
                return 2 | extra;
            }
            case 1: {
                return 3 | extra;
            }
            case 2: {
                return 0 | extra;
            }
            case 3: {
                return 1 | extra;
            }
        }
        return metadata;
    }

    private int geoToPumpkinRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 2: {
                return 0 | extra;
            }
            case 3: {
                return 1 | extra;
            }
            case 0: {
                return 2 | extra;
            }
            case 1: {
                return 3 | extra;
            }
        }
        return metadata;
    }

    private int trapdoorToGeoRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 0: {
                return 2 | extra;
            }
            case 1: {
                return 0 | extra;
            }
            case 2: {
                return 1 | extra;
            }
            case 3: {
                return 3 | extra;
            }
        }
        return metadata;
    }

    private int geoToTrapdoorRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 2: {
                return 0 | extra;
            }
            case 0: {
                return 1 | extra;
            }
            case 1: {
                return 2 | extra;
            }
            case 3: {
                return 3 | extra;
            }
        }
        return metadata;
    }

    private int redstoneRepeaterToGeoRotation(int metadata) {
        return metadata;
    }

    private int geoToRedstoneRepeaterRotation(int metadata) {
        return metadata;
    }

    private int anvilToGeoRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 0: {
                return 0 | extra;
            }
            case 1: {
                return 1 | extra;
            }
        }
        return metadata;
    }

    private int geoToAnvilRotation(int metadata) {
        int dir = metadata & 3;
        int extra = metadata & 0xFFFFFFFC;
        switch (dir) {
            case 1: {
                return 1 | extra;
            }
            case 3: {
                return 1 | extra;
            }
            case 2: {
                return 0 | extra;
            }
            case 0: {
                return 0 | extra;
            }
        }
        return metadata;
    }

    private int railToGeoRotation(int metadata) {
        switch (metadata) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 10;
            }
            case 9: {
                return 9;
            }
        }
        return metadata;
    }

    private int geoToRailRotation(int metadata) {
        switch (metadata) {
            case 0: 
            case 2: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 7;
            }
        }
        return metadata;
    }

    private int poweredRailToGeoRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 0: {
                return 0 | extra;
            }
            case 1: {
                return 1 | extra;
            }
            case 2: {
                return 5 | extra;
            }
            case 3: {
                return 7 | extra;
            }
            case 4: {
                return 4 | extra;
            }
            case 5: {
                return 6 | extra;
            }
        }
        return metadata;
    }

    private int geoToPoweredRailRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (metadata) {
            case 0: 
            case 2: {
                return 0 | extra;
            }
            case 1: 
            case 3: {
                return 1 | extra;
            }
            case 4: {
                return 4 | extra;
            }
            case 5: {
                return 2 | extra;
            }
            case 6: {
                return 5 | extra;
            }
            case 7: {
                return 3 | extra;
            }
        }
        return metadata;
    }

    private int headToGeoRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        if (dir == 1) {
            return 4 | extra;
        }
        switch (dir) {
            case 2: {
                return 0 | extra;
            }
            case 3: {
                return 2 | extra;
            }
            case 4: {
                return 3 | extra;
            }
            case 5: {
                return 1 | extra;
            }
        }
        return metadata;
    }

    private int geoToHeadRotation(int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        if ((dir & 4) != 0) {
            return 1 | extra;
        }
        switch (dir) {
            case 0: {
                return 2 | extra;
            }
            case 2: {
                return 3 | extra;
            }
            case 3: {
                return 4 | extra;
            }
            case 1: {
                return 5 | extra;
            }
        }
        return metadata;
    }

    private int getLocalRotation(int parentRotation, int childRotation) {
        int localRotation = childRotation - parentRotation;
        if (localRotation < 0) {
            localRotation += 4;
        }
        return localRotation;
    }

    private int getGlobalRotation(int parentRotation, int childRotation) {
        int globalRotation = childRotation + parentRotation;
        if (globalRotation >= 4) {
            globalRotation -= 4;
        }
        return globalRotation;
    }

    private int getLocalWoodRotation(int parentRotation, int metadata) {
        if ((parentRotation == 1 || parentRotation == 3) && (metadata & 4) != (metadata & 8)) {
            return metadata & 0xFFFFFFF3 | 0xC & ~(metadata & 0xC);
        }
        return metadata;
    }

    private int getGlobalWoodRotation(int parentRotation, int metadata) {
        if ((parentRotation == 1 || parentRotation == 3) && (metadata & 4) != (metadata & 8)) {
            return metadata & 0xFFFFFFF3 | 0xC & ~(metadata & 0xC);
        }
        return metadata;
    }

    private int getLocalPillarRotation(int parentRotation, int metadata) {
        if (parentRotation == 1 || parentRotation == 3) {
            if (metadata == 3) {
                return 4;
            }
            if (metadata == 4) {
                return 3;
            }
        }
        return metadata;
    }

    private int getGlobalPillarRotation(int parentRotation, int metadata) {
        if (parentRotation == 1 || parentRotation == 3) {
            if (metadata == 3) {
                return 4;
            }
            if (metadata == 4) {
                return 3;
            }
        }
        return metadata;
    }

    private int getLocalPortalRotation(int parentRotation, int metadata) {
        if (parentRotation == 1 || parentRotation == 3) {
            if (metadata == 1) {
                return 2;
            }
            if (metadata == 2) {
                return 1;
            }
        }
        return metadata;
    }

    private int getGlobalPortalRotation(int parentRotation, int metadata) {
        if (parentRotation == 1 || parentRotation == 3) {
            if (metadata == 1) {
                return 2;
            }
            if (metadata == 2) {
                return 1;
            }
        }
        return metadata;
    }

    private int getLocalPistonRotation(int parentRotation, int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 0: {
                return 4 | extra;
            }
            case 1: {
                return 5 | extra;
            }
            case 2: {
                return this.getLocalRotation(parentRotation, 0) | extra;
            }
            case 3: {
                return this.getLocalRotation(parentRotation, 2) | extra;
            }
            case 4: {
                return this.getLocalRotation(parentRotation, 3) | extra;
            }
            case 5: {
                return this.getLocalRotation(parentRotation, 1) | extra;
            }
        }
        return metadata;
    }

    private int getGlobalPistonRotation(int parentRotation, int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        if (dir < 4) {
            switch (this.getGlobalRotation(parentRotation, dir)) {
                case 0: {
                    return 2 | extra;
                }
                case 2: {
                    return 3 | extra;
                }
                case 3: {
                    return 4 | extra;
                }
                case 1: {
                    return 5 | extra;
                }
            }
        } else {
            switch (dir) {
                case 4: {
                    return 0 | extra;
                }
                case 5: {
                    return 1 | extra;
                }
            }
        }
        return metadata;
    }

    private int getLocalVineRotation(int parentRotation, int metadata) {
        int south = metadata & 1;
        int west = metadata & 2;
        int north = metadata & 4;
        int east = metadata & 8;
        if (south > 0) {
            south = 1 << this.getLocalRotation(parentRotation, 2);
        }
        if (west > 0) {
            west = 1 << this.getLocalRotation(parentRotation, 3);
        }
        if (north > 0) {
            north = 1 << this.getLocalRotation(parentRotation, 0);
        }
        if (east > 0) {
            east = 1 << this.getLocalRotation(parentRotation, 1);
        }
        return south | west | north | east;
    }

    private int getGlobalVineRotation(int parentRotation, int metadata) {
        int north = metadata & 1;
        int east = metadata & 2;
        int south = metadata & 4;
        int west = metadata & 8;
        if (north > 0) {
            north = 1 << this.getGlobalRotation(parentRotation, 0);
        }
        if (east > 0) {
            east = 1 << this.getGlobalRotation(parentRotation, 1);
        }
        if (south > 0) {
            south = 1 << this.getGlobalRotation(parentRotation, 2);
        }
        if (west > 0) {
            west = 1 << this.getGlobalRotation(parentRotation, 3);
        }
        int combined = south | west | north | east;
        north = combined & 1;
        east = combined & 2;
        south = combined & 4;
        west = combined & 8;
        if (north > 0) {
            north = 4;
        }
        if (east > 0) {
            east = 8;
        }
        if (south > 0) {
            south = 1;
        }
        if (west > 0) {
            west = 2;
        }
        return south | west | north | east;
    }

    private int getLocalDoorRotation(int parentRotation, int metadata) {
        if ((metadata & 8) == 0) {
            int dir = metadata & 3;
            int extra = metadata & 0xFFFFFFFC;
            switch (dir) {
                case 0: {
                    return this.getLocalRotation(parentRotation, 3) | extra;
                }
                case 1: {
                    return this.getLocalRotation(parentRotation, 0) | extra;
                }
                case 2: {
                    return this.getLocalRotation(parentRotation, 1) | extra;
                }
                case 3: {
                    return this.getLocalRotation(parentRotation, 2) | extra;
                }
            }
        }
        return metadata;
    }

    private int getGlobalDoorRotation(int parentRotation, int metadata) {
        if ((metadata & 8) == 0) {
            int dir = this.getGlobalRotation(parentRotation, metadata & 3);
            int extra = metadata & 0xFFFFFFFC;
            switch (dir) {
                case 3: {
                    return 0 | extra;
                }
                case 0: {
                    return 1 | extra;
                }
                case 1: {
                    return 2 | extra;
                }
                case 2: {
                    return 3 | extra;
                }
            }
        }
        return metadata;
    }

    private int getLocalLeverRotation(int parentRotation, int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        switch (dir) {
            case 1: {
                return this.getLocalRotation(parentRotation, 1) | extra;
            }
            case 2: {
                return this.getLocalRotation(parentRotation, 3) | extra;
            }
            case 3: {
                return this.getLocalRotation(parentRotation, 2) | extra;
            }
            case 4: {
                return this.getLocalRotation(parentRotation, 0) | extra;
            }
            case 0: {
                dir = 4;
            }
            case 5: 
            case 6: 
            case 7: {
                if (parentRotation == 0 || parentRotation == 2) {
                    return dir | extra;
                }
                return dir ^ 3 | extra;
            }
        }
        return metadata;
    }

    private int getGlobalLeverRotation(int parentRotation, int metadata) {
        int dir = metadata & 7;
        int extra = metadata & 8;
        if (dir < 4) {
            dir = this.getGlobalRotation(parentRotation, dir);
        } else if (parentRotation == 1 || parentRotation == 3) {
            dir ^= 3;
        }
        switch (dir) {
            case 0: {
                return 4 | extra;
            }
            case 1: {
                return 1 | extra;
            }
            case 2: {
                return 3 | extra;
            }
            case 3: {
                return 2 | extra;
            }
            case 4: {
                return 0 | extra;
            }
            case 5: 
            case 6: 
            case 7: {
                return dir | extra;
            }
        }
        return metadata;
    }

    private int getLocalHugeMushroomRotation(int parentRotation, int metadata) {
        if (metadata == 0 || metadata == 5 || metadata >= 10 && metadata <= 15) {
            return metadata;
        }
        int dir = 0;
        int corner = 0;
        switch (metadata) {
            case 1: {
                corner = 5;
                dir = 3;
                break;
            }
            case 2: {
                corner = 0;
                dir = 0;
                break;
            }
            case 3: {
                corner = 5;
                dir = 0;
                break;
            }
            case 4: {
                corner = 0;
                dir = 3;
                break;
            }
            case 6: {
                corner = 0;
                dir = 1;
                break;
            }
            case 7: {
                corner = 5;
                dir = 2;
                break;
            }
            case 8: {
                corner = 0;
                dir = 2;
                break;
            }
            case 9: {
                corner = 5;
                dir = 1;
            }
        }
        return this.getLocalRotation(parentRotation, dir) + corner + 1;
    }

    private int getGlobalHugeMushroomRotation(int parentRotation, int metadata) {
        if (metadata == 0 || metadata == 5 || metadata >= 10 && metadata <= 15) {
            return metadata;
        }
        int corner = 0;
        if (metadata > 5) {
            corner = 5;
        }
        int dir = this.getGlobalRotation(parentRotation, metadata - corner - 1);
        switch (dir + corner + 1) {
            case 1: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 1;
            }
        }
        return metadata;
    }

    public int getSize() {
        return this.m_size;
    }

    public void setName(String name) {
        this.m_name = name;
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public String getName() {
        return this.m_name;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.m_visualization) {
            this.m_kMin = 0;
            this.m_swapDir = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
            switch (this.m_swapDir) {
                default: {
                    this.m_iMin = -(this.m_size - 1) / 2;
                    this.m_jMin = 1;
                    break;
                }
                case 1: {
                    this.m_iMin = -this.m_size;
                    this.m_jMin = -(this.m_size - 1) / 2;
                    break;
                }
                case 2: {
                    this.m_iMin = -(this.m_size - 1) / 2;
                    this.m_jMin = -this.m_size;
                    break;
                }
                case 3: {
                    this.m_iMin = 1;
                    this.m_jMin = -(this.m_size - 1) / 2;
                }
            }
            int minX = Math.min(this.field_145851_c + this.m_iMin, this.field_145851_c);
            int maxX = Math.max(this.field_145851_c + this.m_iMin + this.m_size, this.field_145851_c + 1);
            int minY = Math.min(this.field_145848_d + this.m_kMin, this.field_145848_d);
            int maxY = Math.max(this.field_145848_d + this.m_kMin + this.m_size, this.field_145848_d + 1);
            int minZ = Math.min(this.field_145849_e + this.m_jMin, this.field_145849_e);
            int maxZ = Math.max(this.field_145849_e + this.m_jMin + this.m_size, this.field_145849_e + 1);
            return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.m_visualization) {
            return 1048576.0;
        }
        return 4096.0;
    }

    public void copyDetails(GeoChestTileEntity src) {
        this.m_name = src.m_name;
        this.m_prevSwapDir = src.m_prevSwapDir;
    }

    private class ChainInfo {
        private Range3D m_range;
        private int m_numChests = 0;
        private int m_numBlocks = 0;
        private int m_nbtSize = 0;
        public ArrayList<Range3D> m_childExclude;

        public ChainInfo(Range3D range, int numBlocks, int nbtSize) {
            this.m_range = range;
            this.m_numChests = 1;
            this.m_numBlocks = numBlocks;
            this.m_nbtSize = nbtSize;
        }

        public int addChain(ChainInfo chain) {
            this.m_range.addRange(chain.m_range);
            this.m_numChests += chain.m_numChests;
            this.m_numBlocks += chain.m_numBlocks;
            this.m_nbtSize += chain.m_nbtSize;
            if (this.m_numChests > ModGeoChests.MAX_CHESTS_IN_CHAIN) {
                return 1;
            }
            if (this.m_numBlocks > ModGeoChests.MAX_BLOCKS_IN_CHAIN) {
                return 2;
            }
            if (this.m_range.getWidth() > ModGeoChests.MAX_SIZE_IN_CHAIN) {
                return 3;
            }
            if (this.m_range.getHeight() > ModGeoChests.MAX_SIZE_IN_CHAIN) {
                return 4;
            }
            if (this.m_range.getDepth() > ModGeoChests.MAX_SIZE_IN_CHAIN) {
                return 5;
            }
            if (this.m_nbtSize > ModGeoChests.MAX_NBT_IN_CHAIN) {
                return 6;
            }
            return 0;
        }
    }

    private class Range3D {
        private int m_xMin = 0;
        private int m_yMin = 0;
        private int m_zMin = 0;
        private int m_xMax = 0;
        private int m_yMax = 0;
        private int m_zMax = 0;

        public Range3D(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
            int temp;
            this.m_xMin = xMin;
            this.m_yMin = yMin;
            this.m_zMin = zMin;
            this.m_xMax = xMax;
            this.m_yMax = yMax;
            this.m_zMax = zMax;
            if (this.m_xMin > this.m_xMax) {
                temp = this.m_xMin;
                this.m_xMin = this.m_xMax;
                this.m_xMax = temp;
            }
            if (this.m_yMin > this.m_yMax) {
                temp = this.m_yMin;
                this.m_yMin = this.m_yMax;
                this.m_yMax = temp;
            }
            if (this.m_zMin > this.m_zMax) {
                temp = this.m_zMin;
                this.m_zMin = this.m_zMax;
                this.m_zMax = temp;
            }
        }

        public int getWidth() {
            return this.m_xMax - this.m_xMin + 1;
        }

        public int getHeight() {
            return this.m_yMax - this.m_yMin + 1;
        }

        public int getDepth() {
            return this.m_zMax - this.m_zMin + 1;
        }

        public void addRange(Range3D range) {
            this.m_xMin = Math.min(this.m_xMin, range.m_xMin);
            this.m_xMax = Math.max(this.m_xMax, range.m_xMax);
            this.m_yMin = Math.min(this.m_yMin, range.m_yMin);
            this.m_yMax = Math.max(this.m_yMax, range.m_yMax);
            this.m_zMin = Math.min(this.m_zMin, range.m_zMin);
            this.m_zMax = Math.max(this.m_zMax, range.m_zMax);
        }

        public boolean inRange(int x, int y, int z) {
            if (x < this.m_xMin || x > this.m_xMax) {
                return false;
            }
            if (y < this.m_yMin || y > this.m_yMax) {
                return false;
            }
            return z >= this.m_zMin && z <= this.m_zMax;
        }
    }

    private class Point3D {
        public int m_x = 0;
        public int m_y = 0;
        public int m_z = 0;
        public boolean m_in = false;
        public boolean m_out = false;

        public Point3D(int x, int y, int z, boolean in, boolean out) {
            this.m_x = x;
            this.m_y = y;
            this.m_z = z;
            this.m_in = in;
            this.m_out = out;
        }
    }
}

