/*
 * Decompiled with CFR 0.152.
 */
package mod.geochests;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mod.geochests.CommonProxy;
import mod.geochests.CraftingEventListener;
import mod.geochests.GeoChest;
import mod.geochests.GeoChestItem;
import mod.geochests.GeoChestTileEntity;
import mod.geochests.GeoditeBlock;
import mod.geochests.GeoditeItem;
import mod.geochests.GeoditeOreBlock;
import mod.geochests.GeoditeOreGenerator;
import mod.geochests.GeovisualizerItem;
import mod.geochests.GuiHandler;
import mod.geochests.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="ModGeochests", name="Geochests", version="1.0.5")
public class ModGeoChests {
    @Mod.Instance(value="ModGeochests")
    public static ModGeoChests instance;
    @SidedProxy(clientSide="mod.geochests.client.ClientProxy", serverSide="mod.geochests.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs geochestTab;
    public static GeoChest tinyGeochest;
    public static GeoChest smallGeochest;
    public static GeoChest mediumGeochest;
    public static GeoChest largeGeochest;
    public static GeoChest hugeGeochest;
    public static final boolean TEST_MODE = false;
    public static GeoChest testGeochest;
    public static GeoditeOreBlock geoditeOre;
    public static GeoditeOreGenerator geoditeOreGenerator;
    public static GeoditeItem geodite;
    public static GeoditeBlock geoditeBlock;
    public static GeovisualizerItem geovisualizer;
    public static int TEST_GEOCHEST_ID;
    public static int TINY_GEOCHEST_ID;
    public static int SMALL_GEOCHEST_ID;
    public static int MEDIUM_GEOCHEST_ID;
    public static int LARGE_GEOCHEST_ID;
    public static int HUGE_GEOCHEST_ID;
    public static int GEODITE_ORE_ID;
    public static int GEODITE_ID;
    public static int GEODITE_BLOCK_ID;
    public static int GEOVISUALIZER_ID;
    public static int MAX_CHESTS_IN_CHAIN;
    public static int MAX_BLOCKS_IN_CHAIN;
    public static int MAX_SIZE_IN_CHAIN;
    public static int MAX_NBT_IN_CHAIN;
    public static boolean MINEABLE_GEODITE;
    public static boolean CRAFTABLE_GEODITE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        MAX_CHESTS_IN_CHAIN = config.get("limitations", "maxChestsInChain", MAX_CHESTS_IN_CHAIN).getInt();
        MAX_BLOCKS_IN_CHAIN = config.get("limitations", "maxBlocksInChain", MAX_BLOCKS_IN_CHAIN).getInt();
        MAX_SIZE_IN_CHAIN = config.get("limitations", "maxSizeInChain", MAX_SIZE_IN_CHAIN).getInt();
        MAX_NBT_IN_CHAIN = config.get("limitations", "maxNBTInChain", MAX_NBT_IN_CHAIN).getInt();
        MINEABLE_GEODITE = config.get("source", "mineableGeodite", MINEABLE_GEODITE).getBoolean(true);
        CRAFTABLE_GEODITE = config.get("source", "craftableGeodite", CRAFTABLE_GEODITE).getBoolean(true);
        config.save();
        tinyGeochest = new GeoChest(0, "tinyGeochest");
        smallGeochest = new GeoChest(1, "smallGeochest");
        mediumGeochest = new GeoChest(2, "mediumGeochest");
        largeGeochest = new GeoChest(3, "largeGeochest");
        hugeGeochest = new GeoChest(4, "hugeGeochest");
        geoditeOre = new GeoditeOreBlock();
        geoditeOreGenerator = new GeoditeOreGenerator();
        geodite = new GeoditeItem();
        geoditeBlock = new GeoditeBlock();
        geovisualizer = new GeovisualizerItem();
        geochestTab = new CreativeTabs("Geochests"){

            public Item func_78016_d() {
                return Item.func_150898_a((Block)hugeGeochest);
            }

            @SideOnly(value=Side.CLIENT)
            public String func_78024_c() {
                return this.func_78013_b();
            }
        };
        tinyGeochest.func_149647_a(geochestTab);
        smallGeochest.func_149647_a(geochestTab);
        mediumGeochest.func_149647_a(geochestTab);
        largeGeochest.func_149647_a(geochestTab);
        hugeGeochest.func_149647_a(geochestTab);
        geoditeOre.func_149647_a(geochestTab);
        geodite.func_77637_a(geochestTab);
        geoditeBlock.func_149647_a(geochestTab);
        geovisualizer.func_77637_a(geochestTab);
        GameRegistry.registerBlock((Block)tinyGeochest, GeoChestItem.class, (String)"tinyGeochest");
        GameRegistry.registerBlock((Block)smallGeochest, GeoChestItem.class, (String)"smallGeochest");
        GameRegistry.registerBlock((Block)mediumGeochest, GeoChestItem.class, (String)"mediumGeochest");
        GameRegistry.registerBlock((Block)largeGeochest, GeoChestItem.class, (String)"largeGeochest");
        GameRegistry.registerBlock((Block)hugeGeochest, GeoChestItem.class, (String)"hugeGeochest");
        PacketHandler.initPackets();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        GameRegistry.registerWorldGenerator((IWorldGenerator)geoditeOreGenerator, (int)0);
        GameRegistry.registerBlock((Block)geoditeOre, ItemBlock.class, (String)"geoditeOre");
        GameRegistry.registerBlock((Block)geoditeBlock, ItemBlock.class, (String)"geoditeBlock");
        GameRegistry.registerTileEntity(GeoChestTileEntity.class, (String)"GeoChest");
        GameRegistry.registerItem((Item)geodite, (String)"geodite");
        GameRegistry.registerItem((Item)geovisualizer, (String)"geovisualizer");
        LanguageRegistry.addName((Object)((Object)tinyGeochest), (String)"Tiny Geochest");
        LanguageRegistry.addName((Object)((Object)smallGeochest), (String)"Small Geochest");
        LanguageRegistry.addName((Object)((Object)mediumGeochest), (String)"Medium Geochest");
        LanguageRegistry.addName((Object)((Object)largeGeochest), (String)"Large Geochest");
        LanguageRegistry.addName((Object)((Object)hugeGeochest), (String)"Huge Geochest");
        LanguageRegistry.addName((Object)((Object)geoditeOre), (String)"Geodite Ore");
        LanguageRegistry.addName((Object)((Object)geodite), (String)"Geodite");
        LanguageRegistry.addName((Object)((Object)geoditeBlock), (String)"Geodite Block");
        LanguageRegistry.addName((Object)((Object)geovisualizer), (String)"Geovisualizer");
        ItemStack whiteCarpet = new ItemStack(Blocks.field_150404_cg, 1, 0);
        ItemStack yellowCarpet = new ItemStack(Blocks.field_150404_cg, 1, 4);
        ItemStack blueCarpet = new ItemStack(Blocks.field_150404_cg, 1, 11);
        ItemStack redCarpet = new ItemStack(Blocks.field_150404_cg, 1, 14);
        ItemStack blackCarpet = new ItemStack(Blocks.field_150404_cg, 1, 15);
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150325_L, 2, i), (Object[])new Object[]{"x", "x", "x", Character.valueOf('x'), new ItemStack(Blocks.field_150404_cg, 3, i)});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)tinyGeochest), (Object[])new Object[]{"xzx", "xyx", "xxx", Character.valueOf('x'), whiteCarpet, Character.valueOf('y'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('z'), new ItemStack((Item)geodite)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)smallGeochest), (Object[])new Object[]{"xzx", "xyx", "xxx", Character.valueOf('x'), yellowCarpet, Character.valueOf('y'), new ItemStack((Block)tinyGeochest), Character.valueOf('z'), new ItemStack((Item)geodite)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)mediumGeochest), (Object[])new Object[]{"xzx", "xyx", "xxx", Character.valueOf('x'), blueCarpet, Character.valueOf('y'), new ItemStack((Block)smallGeochest), Character.valueOf('z'), new ItemStack((Item)geodite)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)largeGeochest), (Object[])new Object[]{"xzx", "xyx", "xxx", Character.valueOf('x'), redCarpet, Character.valueOf('y'), new ItemStack((Block)mediumGeochest), Character.valueOf('z'), new ItemStack((Item)geodite)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)hugeGeochest), (Object[])new Object[]{"xzx", "xyx", "xxx", Character.valueOf('x'), blackCarpet, Character.valueOf('y'), new ItemStack((Block)largeGeochest), Character.valueOf('z'), new ItemStack((Item)geodite)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)geoditeBlock), (Object[])new Object[]{"xxx", "x x", "xxx", Character.valueOf('x'), new ItemStack((Item)geodite)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)geovisualizer), (Object[])new Object[]{" y", "x ", Character.valueOf('x'), new ItemStack(Items.field_151055_y), Character.valueOf('y'), new ItemStack((Item)geodite)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)geodite, 8), (Object[])new Object[]{new ItemStack((Block)geoditeBlock)});
        if (CRAFTABLE_GEODITE) {
            ItemStack magentaDye = new ItemStack(Items.field_151100_aR, 1, 13);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)geodite, 1), (Object[])new Object[]{new ItemStack(Items.field_151166_bC), magentaDye});
            ItemStack greenDye = new ItemStack(Items.field_151100_aR, 1, 2);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151166_bC, 1), (Object[])new Object[]{new ItemStack((Item)geodite), greenDye});
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)new CraftingEventListener());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        TEST_GEOCHEST_ID = 1005;
        TINY_GEOCHEST_ID = 2628;
        SMALL_GEOCHEST_ID = 2629;
        MEDIUM_GEOCHEST_ID = 2630;
        LARGE_GEOCHEST_ID = 2631;
        HUGE_GEOCHEST_ID = 2632;
        GEODITE_ORE_ID = 2633;
        GEODITE_ID = 2634;
        GEODITE_BLOCK_ID = 2635;
        GEOVISUALIZER_ID = 2636;
        MAX_CHESTS_IN_CHAIN = 200;
        MAX_BLOCKS_IN_CHAIN = 50000;
        MAX_SIZE_IN_CHAIN = 500;
        MAX_NBT_IN_CHAIN = 2000000;
        MINEABLE_GEODITE = true;
        CRAFTABLE_GEODITE = true;
    }
}

